
#include <windows.h>
#include <windowsx.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <commctrl.h>
#include <commdlg.h>


#include <Dshow.h>   //Note: Comment out the section on WINGDI.H in dshow.h, to avoid an "already defined elsewhere" error message

//#include <qedit.h>

#include "main.h"

  BOOL Remote_webcam;


//  BOOL   RXbutton              = TRUE;
//  BOOL   TXbutton              = FALSE;
//  BOOL   PicStart              = FALSE;
  BOOL   Image_mode;
//  BOOL   COLOUR                = TRUE;
  BOOL   IsImageLoaded;

  BOOL   Sending_pic;
  BOOL   Webcam;
  BOOL   VERYLARGE_PIC;
  BOOL   LARGE_PIC;
  BOOL   SMALL_PIC;
  BOOL   FAX;
extern  BOOL   TXwindowOpen;
extern  BOOL   RXwindowOpen;


  HANDLE  hBitmapLeftClickMessage,
          hBitmapTrackbarLabel;
  HWND    hwnd,
          hCtl_TX,
          hwndPicTX,
          hwndPicRX,
          g_hwndTXbutton,
          g_hwndRXbutton,
          hRX,
          hwndWebcam,
          hwndWebcamTX;

  extern  HINSTANCE g_hInst, hThisInstance ;

  BITMAP  bm;
  HBITMAP hTmpBmp;
  HDC     hdcPic, hMarkerDC;
  HPEN    hOldPenmarker, hPenMarker;        


extern  int   picW,tpicW;              //NB. Use separate picW and picH for send functions as will be conflicts if both on at the same time
extern  int   picH,tpicH;
extern  int   pic_decimate;

extern  int line_counter; 


 // for playing
 IGraphBuilder         *pGraphBuilder = 0;
 ICaptureGraphBuilder2 *pCaptureGraphBuilder2 = 0;
 IMediaControl         *pMediaControl = 0;
 IBaseFilter           *pDeviceFilter = 0;// = NULL;

 // to select a video input device
 ICreateDevEnum        *pCreateDevEnum = NULL;
 IEnumMoniker          *pEnumMoniker = NULL;
 IMoniker              *pMoniker = NULL;
 ULONG nFetched = 0;

 // to show webcam on the webcam dialog window
  IVideoWindow*   pVidWin;

 // to select a specific camera (out of a maximum of 6 incl. zero)
  IMoniker *pSelectedMoniker[5];

  HRESULT hr;

  static int camera_number = 0;

// convenient macro for releasing interfaces 
#define SAFE_RELEASE(x) if(x) {x->lpVtbl->Release(x);x=NULL;};

//============================================================================================
// Webcam window and various functions
//============================================================================================
extern LRESULT CALLBACK DIRECTSHOW_WEBCAM_TX_DlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
 
 static BITMAPINFO bmi, bmiMarker;
 static HBITMAP    hMarkerBmp;
 static HDC        hTmpDC;

 char camera_name[5][256];
 int index  = 0;

    switch (uMsg)
    {
        case WM_INITDIALOG:
			{

	   //make sure we do not open more than one instance of the window	   
                TXwindowOpen = TRUE;

       //make sure the window stays on top as SetForegroundWindow does not appear to work in this instance (now it does!)
                SetWindowPos (hwndDlg, HWND_TOPMOST, 10, 10, 0, 0,SWP_SHOWWINDOW | SWP_NOSIZE);   

       //default is Webcam can send pic, but this can change depending upon user preference for duration of program                              
                 if(Webcam == TRUE) SendMessage(GetDlgItem(hwndDlg,IDC_WEBCAM_ON), BM_SETCHECK,1,0);
                 if(Webcam == FALSE)SendMessage(GetDlgItem(hwndDlg,IDC_WEBCAM_ON), BM_SETCHECK,0,0);
 
       //default is large pic
			if(Remote_webcam == FALSE)
			    {
				 VERYLARGE_PIC = FALSE;
                 LARGE_PIC     = TRUE;
                 SMALL_PIC     = FALSE;
                 FAX           = FALSE;   
			     tpicW = 640; tpicH = 480;
                 SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC), BM_SETCHECK,0,0);
                 SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC), BM_SETCHECK,1,0);
                 SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,0,0);
                 SendMessage(GetDlgItem(hwndDlg,IDC_FAX), BM_SETCHECK,0,0);

                }
                  IsImageLoaded = FALSE;  //We are not using a file picture (do I need this here?)
      //Get rid of old objects before grabbing a new frame from the camera
                  DeleteDC(hTmpDC);      
                  DeleteObject(hTmpBmp);
                  DeleteDC(hMarkerDC);                  
                  DeleteObject(hMarkerBmp);
                  DeleteDC(hdcPic);	

 //==================================================================================================================
 // Webcam code (not much error-checking going on here!)
 //==================================================================================================================  
                  hr = CoInitialize(0);
 //================
 // Select a camera
 //================

 // Create CreateDevEnum to list device
                  CoCreateInstance(&CLSID_SystemDeviceEnum,NULL,CLSCTX_INPROC_SERVER,&IID_ICreateDevEnum,(PVOID *)&pCreateDevEnum);
    
 // Create EnumMoniker to list VideoInputDevice 
                  pCreateDevEnum->lpVtbl->CreateClassEnumerator(pCreateDevEnum, &CLSID_VideoInputDeviceCategory, &pEnumMoniker, 0);
                  if (pEnumMoniker == NULL) {
  // this will be shown if there is no capture device
                              TXwindowOpen  = FALSE;
                              Image_mode    = FALSE;
						      Remote_webcam = FALSE;
                         
                              SAFE_RELEASE(pCreateDevEnum); 
                              SAFE_RELEASE(pEnumMoniker); 
                              CoUninitialize();                   
                            
                              EndDialog(hwndDlg, 0);
                              DestroyWindow(hwndDlg);			         

              //    MessageBox(0,"No camera available","Warning",MB_OK);
                              return 0;
                  }

 // reset EnumMoniker
                  pEnumMoniker->lpVtbl->Reset(pEnumMoniker);

 // get each Moniker
 while (pEnumMoniker->lpVtbl->Next(pEnumMoniker, 1, &pMoniker, &nFetched) == S_OK) 
		{
           IPropertyBag *pPropertyBag;
           TCHAR devname[256];

   // bind to IPropertyBag
   hr = pMoniker->lpVtbl->BindToStorage(pMoniker, 0, 0, &IID_IPropertyBag,
     (void **)&pPropertyBag);

 if(SUCCEEDED(hr))
   {
     VARIANT var;

   // get FriendlyName of camera
     var.vt = VT_BSTR;
     hr = pPropertyBag->lpVtbl->Read(pPropertyBag,L"FriendlyName", &var, 0);
      if(hr==NOERROR)
         {

          WideCharToMultiByte(CP_ACP, 0,
          var.bstrVal, -1, devname, sizeof(devname), 0, 0);
  
          sprintf(camera_name[index],"%s",devname); //for later display use perhaps?
	      SendMessage(GetDlgItem(hwndDlg,IDC_CAM_SELECT), CB_ADDSTRING, 0, (LPARAM)camera_name[index]);
          SendMessage(GetDlgItem(hwndDlg,IDC_CAM_SELECT), CB_SETCURSEL, camera_number, 0);
        //  SetWindowText(hwndDlg,camera_name[camera_number]);

          pSelectedMoniker[index] = pMoniker;
          pMoniker->lpVtbl->AddRef(pMoniker);
		  SysFreeString(var.bstrVal);
          VariantClear(&var);
         }        
       pPropertyBag->lpVtbl->Release(pPropertyBag);
   }
    pMoniker->lpVtbl->Release(pMoniker);
    index++;
 }

  //select a camera from the combobox

      if(camera_number > index-1)  //if we try to select a camera that does not exist....(but this cannot occur with the combobox)
			{ TXwindowOpen  = FALSE;
              Image_mode    = FALSE;
              Remote_webcam = FALSE;
                         
              SAFE_RELEASE(pCreateDevEnum); 
              SAFE_RELEASE(pEnumMoniker);
              SAFE_RELEASE(pSelectedMoniker[5]); 
              CoUninitialize();                   
                            
              EndDialog(hwndDlg, 0);
              DestroyWindow(hwndDlg);			 	
			//  MessageBox(0,"Wrong camera","Warning",MB_OK);
			  return 0;
			}
   // now install the selected camera
      pSelectedMoniker[camera_number]->lpVtbl->BindToObject(pSelectedMoniker[camera_number], 0, 0, &IID_IBaseFilter,(void**)&pDeviceFilter );


            if (pDeviceFilter != NULL) 
		      {
   //===========
   // PLAY
   //===========

   // create FilterGraph
                CoCreateInstance(&CLSID_FilterGraph,NULL,CLSCTX_INPROC,&IID_IGraphBuilder,(LPVOID *)&pGraphBuilder);

   // create CaptureGraphBuilder2
                CoCreateInstance(&CLSID_CaptureGraphBuilder2,NULL,CLSCTX_INPROC,&IID_ICaptureGraphBuilder2,(LPVOID *)&pCaptureGraphBuilder2);

   // set FilterGraph
                pCaptureGraphBuilder2->lpVtbl->SetFiltergraph(pCaptureGraphBuilder2,pGraphBuilder);

   // get MediaControl interface
                pGraphBuilder->lpVtbl->QueryInterface(pGraphBuilder,&IID_IMediaControl,(LPVOID *)&pMediaControl);

   // add device filter to FilterGraph
                pGraphBuilder->lpVtbl->AddFilter(pGraphBuilder,pDeviceFilter, L"Video Capture");

   // create Graph
                pCaptureGraphBuilder2->lpVtbl->RenderStream(pCaptureGraphBuilder2,NULL,//&PIN_CATEGORY_PREVIEW,
                                                            &MEDIATYPE_Video, (LPUNKNOWN)pDeviceFilter, NULL, NULL);    //NB. Have to cast pDeviceFilter as LPUNKNOWN to satisfy compiler

   // start the camera
                pMediaControl->lpVtbl->Run(pMediaControl);
     

  // put the camera window into the webcam dialog box window so we can capture the pixels
                pGraphBuilder->lpVtbl->QueryInterface(pGraphBuilder, &IID_IVideoWindow, (void **)&pVidWin);

                pVidWin->lpVtbl->put_Owner(pVidWin,(OAHWND)hwndDlg);       // Put webcam window on dialog window
                pVidWin->lpVtbl->put_WindowStyle(pVidWin,WS_CHILD);     

                pVidWin->lpVtbl->SetWindowPosition(pVidWin, 0,0,640,480);
                pVidWin->lpVtbl->put_Visible(pVidWin,OATRUE);






                if(Remote_webcam == TRUE)SetTimer(hwndDlg,0,2000,NULL); //Start a 2 second timer to give the webcam a chance to get setup before we press the send button remotely
              }

			}
			break;


         case WM_TIMER:

            switch (wParam)
             {
			  case 0:   SendMessage(hwndDlg, WM_COMMAND,IDC_SEND_PIC_BUTTON,0);break;  //This will start sending after 1 second

			  case 1:	if(line_counter < pic_decimate+1)  //close everything down when the picture has been sent. "line_counter" counts down from 240 in the send audio callback
                             {
						      KillTimer(hwndDlg,2);  //Close down the update window timer (do this first or program will crash when BitBlt has nothing to Blit!)
                              TXwindowOpen  = FALSE;
                              Image_mode    = FALSE;
						      Remote_webcam = FALSE;

                              pMediaControl->lpVtbl->Stop(pMediaControl);
	 
                              SAFE_RELEASE(pGraphBuilder); 
                              SAFE_RELEASE(pCaptureGraphBuilder2); 
                              SAFE_RELEASE(pMediaControl); 
                              SAFE_RELEASE(pDeviceFilter); 
                              SAFE_RELEASE(pCreateDevEnum); 
                              SAFE_RELEASE(pEnumMoniker); 
                              SAFE_RELEASE(pVidWin);
					          SAFE_RELEASE(pSelectedMoniker[5]);
                              CoUninitialize();

                              DeleteObject(hMarkerBmp);
                              DeleteDC(hTmpDC);
                              DeleteDC(hMarkerDC);
			                  DeleteDC(hdcPic);
                              Sleep(500);
                         
                              EndDialog(hwndDlg, 0);
                              DestroyWindow(hwndDlg);			
					         }break;

			  case 2:
					    BitBlt (hdcPic, 0, 0, 640-10, 480, hTmpDC, 0, 0, SRCCOPY); //copy "freeze frame" bitmap back onto screen 
                        break;
					
             }
           break;  

		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
   
             case IDC_SEND_PIC_BUTTON:
			  {			
	              KillTimer(hwndDlg,0);  //Close down the "start" timer once the send is in progress
				  SetTimer(hwndDlg,1,100,NULL);//Start a watchdog timer to check whether the frame has been sent, and close down the webcam window, ready for a new one
                  if(Webcam == FALSE)break;//do not send unless allowed
			    //Get rid of old objects before grabbing a new frame from the camera
                  DeleteDC(hTmpDC);      
                  DeleteObject(hTmpBmp);
                  DeleteDC(hMarkerDC);                  
                  DeleteObject(hMarkerBmp);
                  DeleteDC(hdcPic);	


          // Pause the camera while we grab a frame (don't need to do this but it gives an indication on what is being sent)
             pMediaControl->lpVtbl->Stop(pMediaControl);


           //Set up a fresh bitmap for the camera
             hdcPic = GetDC(GetDlgItem(hwndDlg,ID_PIC_TX_WINDOW));           

			 bmi.bmiHeader.biSize        = sizeof(bmi.bmiHeader);
             bmi.bmiHeader.biWidth       = 640;
             bmi.bmiHeader.biHeight      = 480+2;  //make this one larger than the picture (240) else crash!
             bmi.bmiHeader.biPlanes      = 1;
             bmi.bmiHeader.biBitCount    = 32;
             bmi.bmiHeader.biCompression = BI_RGB;

 
             hTmpDC = CreateCompatibleDC (hdcPic);
             hTmpBmp = CreateDIBSection(hTmpDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
             SelectObject( hTmpDC, hTmpBmp);
             BitBlt (hTmpDC, 0, 0, 640, 480, hdcPic, 0, 0, SRCCOPY); //copy picture into bitmap 

       //Create a DC for the picture send progress bar (a line that draws horizontally and is not deleted)
			 bmiMarker.bmiHeader.biSize        = sizeof(bmiMarker.bmiHeader);
             bmiMarker.bmiHeader.biWidth       = 10;
             bmiMarker.bmiHeader.biHeight      = 480;
             bmiMarker.bmiHeader.biPlanes      = 1;
             bmiMarker.bmiHeader.biBitCount    = 32;
             bmiMarker.bmiHeader.biCompression = BI_RGB;

             hMarkerDC = CreateCompatibleDC (hdcPic);
             hMarkerBmp = CreateDIBSection(hMarkerDC, &bmi, DIB_RGB_COLORS,0,0,0);//(VOID **)&pBits, 0, 0);
             SelectObject( hMarkerDC, hMarkerBmp); 
    
           
				 Image_mode = TRUE;
                 int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
			     SendMessage(hCtl_TX, EM_SETSEL, len, len);
		         if(VERYLARGE_PIC==TRUE) SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" V");
		         if(LARGE_PIC==TRUE)     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" L"); //don't forget the space after the direction call
		         if(SMALL_PIC==TRUE)     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" S");
                 if(FAX==TRUE)           SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" F");

				 SendMessage(g_hwndTXbutton,WM_LBUTTONDOWN,0,0);     //MUST use SendMessage instead of PostMessage otherwise SetForegroundWindow is too early
				 line_counter = 480;                                 //We start line count from 480 rather than up from 0 as Windoze images are upside down!
				 PatBlt(hMarkerDC,0,0,10,480,BLACKNESS);             //Clear the picture send progress bar               

               //   pVidWin->lpVtbl->put_Visible(pVidWin,OAFALSE); //hand control back to main dialog
                 KillTimer(hwndDlg,2);  //Close down the update window timer
				 SetTimer(hwndDlg,2,100,NULL); //start a new one to ensure the "freeze frame" gets updated


			    SetForegroundWindow(hwndDlg);
	

		      } 			 
              break;

           case IDC_VIDEO_CONTROLS:
				{
  // camera properties dialog
                ISpecifyPropertyPages *pSpec;
                    CAUUID cauuid;
                    hr = pDeviceFilter->lpVtbl->QueryInterface(pDeviceFilter,&IID_ISpecifyPropertyPages,
                        (void **)&pSpec);
                    if(hr == S_OK) {
                        hr = pSpec->lpVtbl->GetPages(pSpec,&cauuid);
                        hr = OleCreatePropertyFrame(hwndDlg, 30, 30, NULL, 1,
                            (IUnknown **)&pDeviceFilter, cauuid.cElems,
                            (GUID *)cauuid.pElems, 0, 0, NULL);
                        CoTaskMemFree(cauuid.pElems);
                        pSpec->lpVtbl->Release(pSpec);
                        }
                }
              break;

  // Accept changed camera
           case IDOK:
				{
                 camera_number = SendMessage(GetDlgItem(hwndDlg,IDC_CAM_SELECT),CB_GETCURSEL,0,0);
  // stop the process
	             pMediaControl->lpVtbl->Stop(pMediaControl);
  // now install the selected camera
                 pSelectedMoniker[camera_number]->lpVtbl->BindToObject(pSelectedMoniker[camera_number], 0, 0, &IID_IBaseFilter,(void**)&pDeviceFilter );
                
   // and start over

                 CoCreateInstance(&CLSID_FilterGraph,NULL,CLSCTX_INPROC,&IID_IGraphBuilder,(LPVOID *)&pGraphBuilder);
                 CoCreateInstance(&CLSID_CaptureGraphBuilder2,NULL,CLSCTX_INPROC,&IID_ICaptureGraphBuilder2,(LPVOID *)&pCaptureGraphBuilder2);
                 pCaptureGraphBuilder2->lpVtbl->SetFiltergraph(pCaptureGraphBuilder2,pGraphBuilder);
                 pGraphBuilder->lpVtbl->QueryInterface(pGraphBuilder,&IID_IMediaControl,(LPVOID *)&pMediaControl);
                 pGraphBuilder->lpVtbl->AddFilter(pGraphBuilder,pDeviceFilter, L"Video Capture");
                 pCaptureGraphBuilder2->lpVtbl->RenderStream(pCaptureGraphBuilder2,NULL,//&PIN_CATEGORY_PREVIEW,
                                                             &MEDIATYPE_Video, (LPUNKNOWN)pDeviceFilter, NULL, NULL);    //NB. Have to cast pDeviceFilter as LPUNKNOWN to satisfy compiler
                 pMediaControl->lpVtbl->Run(pMediaControl);     
                 pGraphBuilder->lpVtbl->QueryInterface(pGraphBuilder, &IID_IVideoWindow, (void **)&pVidWin);
                 pVidWin->lpVtbl->put_Owner(pVidWin,(OAHWND)hwndDlg);       // Put webcam window on dialog window
                 pVidWin->lpVtbl->put_WindowStyle(pVidWin,WS_CHILD);     
                 pVidWin->lpVtbl->SetWindowPosition(pVidWin, 0,0,640,480);
                 pVidWin->lpVtbl->put_Visible(pVidWin,OATRUE);
 
			//	SetWindowText(hwndDlg,camera_name[camera_number]);
                }
              break;


/*           case IDC_VIDEO_FORMAT:
 // camera format dialog
                  {
                    // this dialog will not work while previewing - it might change
                    // the output format!
                    
                    IAMStreamConfig *pSC;

                    // This dialog changes the preview format, so it might affect
                    // the format being drawn.  Our app's window size is taken
                    // from the size of the capture pin's video, not the preview
                    // pin, so changing that here won't have any effect. All in all,
                    // this probably won't be a terribly useful dialog in this app.
                    hr = pCaptureGraphBuilder2->lpVtbl->FindInterface(pCaptureGraphBuilder2,&PIN_CATEGORY_PREVIEW,
                        &MEDIATYPE_Interleaved, pDeviceFilter,
                        &IID_IAMStreamConfig, (void **)&pSC);
char msg[80];
					sprintf(msg,"%d",hr);
					MessageBox(0,msg,"",MB_OK);	
                    if(hr != NOERROR)
                        hr = pCaptureGraphBuilder2->lpVtbl->FindInterface(pCaptureGraphBuilder2,&PIN_CATEGORY_PREVIEW,
                            &MEDIATYPE_Video, pDeviceFilter,
                            &IID_IAMStreamConfig, (void **)&pSC);
//char msg[80];
		//			sprintf(msg,"%d",hr);
				//	MessageBox(0,msg,"",MB_OK);	
                        if(hr != NOERROR)break;
									

                    ISpecifyPropertyPages *pSpec;
                    CAUUID cauuid;
                    hr = pSC->lpVtbl->QueryInterface(pSC,&IID_ISpecifyPropertyPages,
                        (void **)&pSpec);
                    if(hr == S_OK) {
                            hr = pSpec->lpVtbl->GetPages(pSpec,&cauuid);
                            if(hr == S_OK && cauuid.cElems > 0) {
                            hr = OleCreatePropertyFrame(hwndDlg, 30, 30, NULL, 1,
                                (IUnknown **)&pSC, cauuid.cElems,
                                (GUID *)cauuid.pElems, 0, 0, NULL);
                            CoTaskMemFree(cauuid.pElems);
						}
						else
						{break;}
                            pSpec->lpVtbl->Release(pSpec);
                    }
                    pSC->lpVtbl->Release(pSC);
                  }
                                                                               
              break;
*/
           case IDC_SMALL_PIC:
			   {
                VERYLARGE_PIC = FALSE;
                LARGE_PIC     = FALSE;
                SMALL_PIC     = TRUE;
                FAX           = FALSE;   
				tpicH = 480; tpicW = 640;         //It is always 320x240 for send pic 
                SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC),     BM_SETCHECK,1,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_FAX),           BM_SETCHECK,0,0);
			   }
			    break;

           case IDC_LARGE_PIC:
		   	   {
                VERYLARGE_PIC = FALSE;
                LARGE_PIC     = TRUE;
                SMALL_PIC     = FALSE;
                FAX           = FALSE;   
                tpicH = 480; tpicW = 640;
                SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC),     BM_SETCHECK,1,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_FAX),           BM_SETCHECK,0,0);
		   	   }
                break;

           case IDC_VERYLARGE_PIC:
		   	   {
                VERYLARGE_PIC = TRUE;
                LARGE_PIC     = FALSE;
                SMALL_PIC     = FALSE;
                FAX           = FALSE;   
                tpicH = 480; tpicW = 640;
                SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,1,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_FAX),           BM_SETCHECK,0,0);						;
		   	   }
                break;

           case IDC_FAX:
		   	   {
                VERYLARGE_PIC = FALSE;
                LARGE_PIC     = FALSE;
                SMALL_PIC     = FALSE;
                FAX           = TRUE;
                tpicH = 480; tpicW = 640;
                SendMessage(GetDlgItem(hwndDlg,IDC_VERYLARGE_PIC), BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_SMALL_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_LARGE_PIC),     BM_SETCHECK,0,0);
                SendMessage(GetDlgItem(hwndDlg,IDC_FAX),           BM_SETCHECK,1,0);
		   	   }
                break;


           case IDC_WEBCAM_ON:
				{
                 if(SendMessage(GetDlgItem(hwndDlg,IDC_WEBCAM_ON), BM_GETCHECK, 0, 0)==1)Webcam = TRUE;
				 if(SendMessage(GetDlgItem(hwndDlg,IDC_WEBCAM_ON), BM_GETCHECK, 0, 0)==0)Webcam = FALSE;
				}
				 break;
		    }
            break;


    case WM_PAINT:
         {
 //Update the send picture 
  
           BitBlt ( hdcPic, 0, 0, 640, 480, hTmpDC, 0, 0, SRCCOPY); //copy bitmap back onto screen (don't need this as directshow updates continuously)

		 }
	     break;

 
        case WM_CLOSE:

            TXwindowOpen = FALSE;
            Image_mode   = FALSE;
			Remote_webcam = FALSE;

			KillTimer(hwndDlg,1);
			KillTimer(hwndDlg,2);
//Stop the camera 
            pMediaControl->lpVtbl->Stop(pMediaControl);
//Release all of the COM objects
            SAFE_RELEASE(pGraphBuilder); 
            SAFE_RELEASE(pCaptureGraphBuilder2); 
            SAFE_RELEASE(pMediaControl); 
            SAFE_RELEASE(pDeviceFilter); 
            SAFE_RELEASE(pCreateDevEnum); 
            SAFE_RELEASE(pEnumMoniker); 
            SAFE_RELEASE(pVidWin);
			SAFE_RELEASE(pSelectedMoniker[5]);

 // finalize COM
            CoUninitialize();
 //And all the other stuff			
            ReleaseDC(hwndWebcamTX,hdcPic);	  
        	      
            DeleteObject(hMarkerBmp);
            DeleteDC(hTmpDC);
            DeleteDC(hMarkerDC);
			DeleteDC(hdcPic);

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}


void Directshow_webcam(void)
{
  if(TXwindowOpen==TRUE)MessageBox(hwnd,"Window already open","Warning!",MB_OK | MB_ICONWARNING);	 
  if(TXwindowOpen==FALSE)CreateDialog(hThisInstance, MAKEINTRESOURCE(DLG_DIRECTSHOW_WEBCAM_TX), NULL, (DLGPROC)DIRECTSHOW_WEBCAM_TX_DlgProc); //DO NOT use DialogBox, otherwise it will not respond remotely! 
}
